*** Table 2:  Congressional Election (county-level)

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 

*** OPEN MAIN COUNTY DTA 
use  "$data/main_county_FD.dta", clear

foreach t in 40 50 60 {
	
gen fr_black_40_y`t'=fr_black_40*y_`t'
gen cong_dem_40_y`t'=cong_dem_40*y_`t'
gen dem_40_y`t'=dem_40*y_`t'

}


egen cst=group(statefip county)
egen stateyear=group(statefip year)
egen regionyear=group(region year)


xtset cst year, delta(10)
global controls fr_black_40_y* dem_40_y*


********************************************************************

cd "$output"


// Panel A 

* col. 1 
reg D_cong_dem D_fr_black  i.stateyear [aw=totpop_40], cl(cst)
      su D_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon replace ///
keep (D_fr_black)  dec(3)  addtext(spec, FD, Weights, X, Black share 40, ., Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')


* col. 2
reg D_cong_dem D_fr_black fr_black_40_y* i.stateyear [aw=totpop_40], cl(cst)
      su D_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3)  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')


* col. 3
reg D_cong_dem D_fr_black $controls i.stateyear [aw=totpop_40], cl(cst)
      su D_cong_dem  [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3)  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')


* col. 4 
ivreg2 D_cong_dem (D_fr_black=Z_p40)  i.stateyear   [aw=totpop_40], cl(cst)  ffirst savefirst
local F=e(widstat)
      su D_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, FD, Weights, X, Black share 40, ., Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_C.xls, excel nocon replace ///
keep (Z_p40)  dec(3)


* col. 5 
ivreg2 D_cong_dem (D_fr_black=Z_p40)  i.stateyear fr_black_40_y* [aw=totpop_40] , cl(cst)  ffirst savefirst
local F=e(widstat)
      su D_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (Z_p40)  dec(3)


* col. 6 
ivreg2 D_cong_dem (D_fr_black=Z_p40)  i.stateyear $controls [aw=totpop_40],  cl(cst)  ffirst savefirst
local F=e(widstat)
      su D_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (Z_p40)  dec(3)

* col. 7 
ivreg2 LD_cong_dem (LD_fr_black=LD_Z_p40)  i.statefip fr_black_40 dem_40  [aw=totpop_40] if year==1940, cl(cst)  ffirst savefirst
local F=e(widstat)
      su LD_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su LD_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su LD_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_A.xls, excel nocon append ///
keep (LD_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, LD, Weights, X, Black share 40, X, Dem 40, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')
 
est restore _ivreg2_LD_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (LD_Z_p40)  dec(3)




// Panel B 

* col. 1
reg D_cong_turnout D_fr_black  i.stateyear [aw=totpop_40], cl(cst)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon replace ///
keep (D_fr_black)  dec(3)  addtext(spec, FD, Weights, X, Black share 40, ., Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

* col. 2
reg D_cong_turnout D_fr_black fr_black_40_y*   i.stateyear [aw=totpop_40], cl(cst)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon append ///
keep (D_fr_black)  dec(3)  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

* col. 3
reg D_cong_turnout D_fr_black $controls i.stateyear [aw=totpop_40], cl(cst)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon append ///
keep (D_fr_black)  dec(3)  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')


* col. 4 
ivreg2 D_cong_turnout (D_fr_black=Z_p40)  i.stateyear   [aw=totpop_40], cl(cst)  ffirst savefirst
local F=e(widstat)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, FD, Weights, X, Black share 40, ., Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (Z_p40)  dec(3)

* col. 5 
ivreg2 D_cong_turnout (D_fr_black=Z_p40)  i.stateyear fr_black_40_y* [aw=totpop_40], cl(cst)  ffirst savefirst
local F=e(widstat)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, ., Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (Z_p40)  dec(3)


* col. 6 
ivreg2 D_cong_turnout (D_fr_black=Z_p40)  i.stateyear $controls [aw=totpop_40], cl(cst)  ffirst savefirst
local F=e(widstat)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, FD, Weights, X, Black share 40, X, Dem 40, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (Z_p40)  dec(3)


* col. 7 
ivreg2 LD_cong_turnout (LD_fr_black=LD_Z_p40)  i.statefip fr_black_40 dem_40  [aw=totpop_40] if year==1940, cl(cst)  ffirst savefirst
local F=e(widstat)
      su LD_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su LD_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su LD_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_B.xls, excel nocon append ///
keep (LD_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(spec, LD, Weights, X, Black share 40, X, Dem 40, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')
 
est restore _ivreg2_LD_fr_black
outreg2 using Table2_C.xls, excel nocon append ///
keep (LD_Z_p40)  dec(3)
 